/**HEADER********************************************************************
* 
* Copyright (c) 2008 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: user_config.h$
* $Version : 1.0.0.0$
* $Date    : May-15-2012$
*
* Comments:
*
*   User configuration for MQX components
*
*END************************************************************************/

#ifndef __user_config_h__
#define __user_config_h__

/* mandatory CPU identification */
#define MQX_CPU                 PSP_CPU_FXLC95000

/*
** BSP settings
*/

#define BSPCFG_ENABLE_RTCDEV        0
#define BSPCFG_ENABLE_TTYA          0
#define BSPCFG_ENABLE_TTYB          0 // Don't include serial for printf, hht 101011
#define BSPCFG_ENABLE_ITTYA         0
#define BSPCFG_ENABLE_ITTYB         0
#define BSPCFG_ENABLE_I2C0          0
#define BSPCFG_ENABLE_I2C1          0
#define BSPCFG_ENABLE_II2C0         0
#define BSPCFG_ENABLE_II2C1         0
#define BSPCFG_ENABLE_GPIODEV       0
#define BSPCFG_ENABLE_ADC           0
#define BSPCFG_ENABLE_SPI0          0
#define BSPCFG_ENABLE_ISPI0         0
#define BSPCFG_ENABLE_SPI1          0
#define BSPCFG_ENABLE_ISPI1         0
#define BSPCFG_ENABLE_FLASHX        0


/*
** board-specific MQX settings
*/

#define MQX_COMPONENT_DESTRUCTION   1
#define MQX_CHECK_ERRORS            0



#ifdef BSP_PSP_CORE_BUILD  // See define in build settings menu
  #define MQX_USER_STACK_SUPPORT              1
  #define MQX_USER_IRQ_STACK_SUPPORT          1
#else
  #define MQX_USER_STACK_SUPPORT              0
  #define MQX_USER_IRQ_STACK_SUPPORT          0 
#endif


#ifndef MQX_USER_STACKSIZE_LIMIT_BITS
  // Used when MQX_USER_STACK_SUPPORT=1
  #define MQX_USER_STACKSIZE_LIMIT_BITS   16                                    // 16=64kb limit, 32 is max
  #define MQX_USER_STACKSIZE_MASK         ((1<<MQX_USER_STACKSIZE_LIMIT_BITS)-1)
  #define MQX_USER_STACKSIZE_SHIFT_BITS   (32-MQX_USER_STACKSIZE_LIMIT_BITS)    // Bits to shift left/right
#endif


#ifndef MQX_USER_IRQ_STACKSIZE_LIMIT_BITS
  // Used when MQX_USER_IRQ_STACK_SUPPORT=1
  #define MQX_USER_IRQ_STACKSIZE_LIMIT_BITS   16    // 16=64kb limit, 32 is max
  #define MQX_USER_IRQ_STACKSIZE_MASK         ((1<<MQX_USER_IRQ_STACKSIZE_LIMIT_BITS)-1)
  #define MQX_USER_IRQ_STACK_SHIFT_BITS       (32-MQX_USER_IRQ_STACKSIZE_LIMIT_BITS)    // Bits to shift left/right
#endif



/*
** board-specific Shell settings
*/

#define SHELLCFG_USES_RTCS          0           
 
/*
** include common settings
*/

/* use the rest of defaults from small-RAM-device profile */
//#include "small_ram_config.h"
#include "fxlc95000eval_ram_config.h"


/* and enable verification checks in kernel */
#include "verif_enabled_config.h"

#endif
/* EOF */
